#include <windows.h>
#include <string.h>
#include "AmiKick.h"

// Funkcje odwracaj kolejno bajtw (Big-Endian na Little-Endian i vice-versa)
#define SWAP16(n) (((n&0xFF00)>>8)|((n&0x00FF)<<8)) // SWAP16(0x1122) = 0x2211
#define SWAP32(n) ((SWAP16((n&0xFFFF0000)>>16))|((SWAP16(n&0x0000FFFF))<<16)) // SWAP32(0x11223344) = 0x44332211

HICON hIcon;
HFONT hFont;
HANDLE hFile;
HBRUSH hbLis;
OFSTRUCT ofs;
HINSTANCE hInst;
OPENFILENAME ofn;
char *typ[] = {""};
signed char mpri[70];
LPSTR mBuf, tBuf, tpos, madr[70], mend[70], tadr[70];
char mnam[70][33] = {""}, mver[70][70] = {""}, mtyp[70];
int csel, mnum, load, ksar, ks1m, ksam, scrx, scry, winx = 455, winy = 480; // szeroko, wysoko gwnego okna programu
DWORD hCol, fsih, fsil, ftmp, base, skip, ksum, ktmp, ktm2;
HWND hWnd, hBut0, hBut1, hBut2, hBut3, hBut4, hBut5, hBut6, hLis0, hWin0, hWin1, hWin2, hWin3, hTemp;
char ctst[1], scla[] = "AmiKickClass", fnam[MAX_PATH], smsg[133], stmp[178], stmy[5], stm0[34],
stm1[] = "Resident modules:", stm2[] = " Version:\nAddress:\n    Type:\n  Priority:", stm3[] = ".\nMaybe it is used by other program.",
stm4[] = " this file.\nMaybe disk has read/write errors.", stm5[] = ".\nThis is not Kickstart image.", stm6[] = ".\nOnly original Kickstarts are supported.",
stm7[] = "Invalid module ", stm8[] = ".\nMaybe image is corrupted.\nOffset: ", snam[] = "AmiKick 1.16",
sver[] = "AmiKick 1.16 (08.02.2026)\n\nCreated by Roman Brenski (RomanWorkshop)\n\nThis program is freeware.";
char *ver[] = {"0.7", "1.0", "1.1 (31.34)", "1.2 (33.166)", "1.2 (33.180)", "1.3 (34.5)", "1.4 alpha 15 (36.15)",
"1.4 beta (36.16)", "1.4 alpha 18 (36.2)", "2.0 beta (36.28)", "2.0 beta (36.67)", "2.01 (36.141)", "2.01 (36.143)",
"2.02 (36.207)", "2.03 (37.92)", "2.04 (37.175)", "2.04 (37.210)", "2.05 (37.299)", "2.05 (37.300)", "2.05 (37.350)",
"3.0 beta (39.65)", "3.0 (39.106)", "3.1 (40.55)", "3.1 (40.60)", "3.1 (40.62)", "3.1 (40.63)", "3.1 (40.68)", "3.1 (40.70)",
"3.5 (40.71)", "3.5 (44.1)", "CDTV extended 1.0 (34.1001)", "CDTV extended 2.7 (37.201)", "CDTV extended 2.30 (37.201)",
"CD32 extended 3.1 (40.60)", "3.2 beta (43.1)", "3.x (45.57)", "3.x (45.61)", "3.1 (40.72)", "3.x (45.62)", "3.x (45.64)",
"3.x (44.72)", "3.1.4 (46.143)", "3.2 (47.96)", "CDTV extended 2.35 (37.201)", "CDTV extended 3.2 (37.202)", "3.x (45.66)",
"3.2 (47.102)", "3.1 (40.69)", "3.1 beta (40.3)", "3.1 beta (40.9)", "1.2.1 (34.4)", "3.1 (40.16)", "3.2 (47.111)",
"CD32 extended 3.1 (40.16)", "CDTV extended 0.1 beta", "CDTV-CR extended 3.32", "CDTV-CR extended 3.34", "CDTV-CR extended 3.40",
"CDTV-CR extended 3.44", "1.4 beta (36.3)", "2.0 beta (36.65)", "2.0 beta (36.72)", "2.02 (36.202)", "2.02 (36.209)",
"2.03 (37.74)", "3.1 (40.71)", "AROS (46.10)", "AROS (46.11)", "AROS (46.12)", "3.2 (47.115)", "unknown version"};
char *ami[] = {"1000 NTSC", "1000 NTSC", "", "1000", "500/1000/2000", "", "3000", "3000", "3000", "3000", "3000",
"3000", "3000", "3000", "3000", "", "600/2500/3000", "600", "600(HD)", "600(HD)", "3000", "", "", "CD32", "",
"500/600/2000", "", "", "4000", "1200", "CDTV", "CDTV", "", "CD32", "Walker (prototype)", "4000T", "",
"", "", "", "Vampire 600 v2", "", "", "CDTV", "CDTV", "", "", "1200", "", "4000", "500/1000/2000", "CD32", "",
"CD32", "CDTV", "CDTV-CR", "CDTV-CR", "CDTV-CR", "CDTV-CR", "3000", "3000", "3000", "3000", "3000", "3000", "",
"", "", "", ""};
char *inf[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"(hack)", "", "", "", "(hack)", "", "", "", "", "", "", "(Cloanto)", "(Cloanto)", "(Hyperion)", "(Cloanto)",
"(Cloanto)", "", "(Hyperion)", "(Hyperion)", "(C4ptFuture)", "(Hyperion)", "(Cloanto)", "(Hyperion)",
"(hack Harry Sintonen)", "", "", "", "", "(Hyperion)", "", "", "", "", "", "", "", "", "", "(bad)", "", "",
"(Gateway)", "", "", "", "(Hyperion)"};
// Rok produkcji obsugiwanych Kickstartw (ich najnowszego moduu)
int yea[] = {1985, 1985, 0, 1986, 0, 0, 1989, 1990, 1989, 1990, 1990, 1990, 1990, 1990, 1991, 1991, 1991, 1991,
1991, 1992, 1992, 1992, 1993, 1993, 1993, 1993, 1993, 1994, 1996, 2001, 1991, 1992, 0, 1993, 1996, 2004, 2014,
2016, 2014, 2016, 2017, 2018, 2021, 2021, 2021, 2017, 2021, 1993, 1993, 1993, 1987, 1993, 2023, 1993, 1990,
1992, 1992, 1992, 1992, 1990, 1990, 1990, 1990, 1990, 1991, 1998, 0, 0, 0, 2025};
// Dane z wersjami obsugiwanych Kickstartw (zapis w systemie Little-Endian)
DWORD tst[] = {0xFFFFFFFF, 0x06001B00, 0xFFFFFFFF, 0x02000100, 0xFFFFFFFF, 0x22001F00, 0xA6002100, 0xBD002100,
0xB4002100, 0xC0002100, 0x05002200, 0x02002200, 0x0F002400, 0x12002400, 0x10002400, 0x54002400, 0x02002400, 0x3B002400,
0x1C002400, 0x58002400, 0x43002400, 0xF2032400, 0x8D002400, 0xE8032400, 0x8F002400, 0xE8032400, 0xCF002400, 0x8E002400,
0x5C002500, 0x32002500, 0xAF002500, 0x84002500, 0xD2002500, 0x97002500, 0x2B012500, 0x97002500, 0x2C012500, 0x97002500,
0x5E012500, 0x98002500, 0x41002700, 0x1B002700, 0x6A002700, 0x2F002700, 0x37002800, 0x09002800, 0x3C002800, 0x09002800,
0x3E002800, 0x0A002800, 0x3F002800, 0x0A002800, 0x44002800, 0x0A002800, 0x46002800, 0x0A002800, 0x47002800, 0x0A002800,
0x01002C00, 0x01002C00, 0xFFFFFFFF, 0xE9032200, 0xE7032500, 0xC9002500, 0x1E000200, 0xC9002500, 0x3C002800, 0xE000FC4A,
0x01002B00, 0x04002B00, 0x39002D00, 0x14002D00, 0x3D002D00, 0x14002D00, 0x48002800, 0x0C002800, 0x3E002D00, 0x15002D00,
0x40002D00, 0x17002D00, 0x48002C00, 0x0C002C00, 0x8F002E00, 0x2D002E00, 0x60002F00, 0x07002F00, 0x23000200, 0xC9002500,
0x01007100, 0xC9002500, 0x42002D00, 0x19002D00, 0x66002F00, 0x08002F00, 0x45002800, 0x0A002800, 0x03002800, 0x02002800,
0x09002800, 0x06002800, 0x04002200, 0x02002200, 0x10002800, 0x06002800, 0x6F002F00, 0x0A002F00, 0x10002800, 0xFC4A0000,
0xFFFFFFFF, 0xE8032200, 0x20000300, 0x0000FFFF, 0x22000300, 0x0000FFFF, 0x28000300, 0x0000FFFF, 0x2C000300, 0x0000FFFF,
0x03002400, 0x42002400, 0x41002400, 0xF2032400, 0x48002400, 0xD5072400, 0xCA002400, 0x8E002400, 0xD1002400, 0x8E002400,
0x4A002500, 0x34002500, 0x47002800, 0x0B002800, 0x0A002E00, 0x0A002E00, 0x0B002E00, 0x0B002E00, 0x0C002E00, 0x0C002E00,
0x73002F00, 0x0D002F00};
// Prawidowa liczba moduw w obsugiwanych Kickstartach (pomniejszona o 1)
char mod[] = {22, 21, 21, 22, 0, 0, 22, 43, 37, 39, 39, 38, 40, 40, 39, 0, 42, 41, 42, 42, 41, 0, 41, 42, 0, 42, 0,
0, 41, 43, 11, 12, 13, 16, 40, 40, 0, 0, 0, 0, 42, 0, 0, 13, 12, 0, 0, 42, 0, 41, 23, 41, 0, 15, 10, 15, 15, 19, 18,
38, 39, 39, 40, 40, 39, 0, 0, 0, 0, 0};
// Minimalny model procesora 680x0 wymagany do dziaania obsugiwanych Kickstartw
char cpu[] = {0, 0, 0, 0, 0, 0, 0, 3, 1, 3, 1, 0, 4, 4, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1, 0, 0, 0,
0, 2, 1, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0,
1, 0, 1, 4, 4, 0, 0, 0, 0, 0, 0};
// 0 = 68000/24-bit, 1 = 68020/24-bit, 2 = 68020/32-bit, 3 = 68030/24-bit, 4 = 68030/32-bit, 5 = 68080/32-bit (Vampire)
char *sfpu, *scpu[] = {"00 (24", "20 (24", "20 (32", "30 (24", "30 (32", "80 (32"};

/* Funkcja szuka "dnum"-bajtw danych spod adresu "data" w "bnum"-bajtach bloku pamici, ktrego pocztek znajduje si
   pod adresem "buff". Minimalna liczba szukanych danych to 2-bajty. Jeli dane zostan znalezione, to funkcja zwraca
   adres pierwszego bajtu, pod ktrym si one znajduj w bloku pamici. W przeciwnym razie funkcja zwraca 0. */
LPSTR *FindData(LPSTR *buff, long bnum, char *data, int dnum)
{
Z: fsih = memchr(buff, data[0], bnum); // Szukanie pierwszego bajtu danych
if(fsih) // Znaleziono pierwszy bajt danych
 {if(fsih+dnum > (long)buff+bnum) return 0; // Szukane dane s dusze od liczby bajtw, ktre pozostay do koca bloku pamici
  if(!memcmp(fsih+1, data+1, dnum-1)) return fsih; // Znaleziono kolejne bajty danych
  else // Nie znaleziono kolejnych bajtw danych (zwikszenie pozycji szukania o 1 i ponowne szukanie)
   {bnum = bnum-(fsih+1-(long)buff);
    buff = fsih+1;
    goto Z;}}
else return 0; // Nie znaleziono pierwszego bajtu danych
}

/* Krok 4: procedura gwnego okna programu */
LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
switch(Message)
 {
// Tworzenie zawartoci gwnego okna programu
 case WM_CREATE:
 load = 0; // Nie ma zarezerwowanej pamici do oddania z wczytanym obrazem Kickstartu
 hFont = GetStockObject(DEFAULT_GUI_FONT); // Domylna czcionka systemu Windows
 hCol = GetSysColor(COLOR_BTNFACE); // Kolor ta listy "Resident modules"
 hbLis = CreateSolidBrush(hCol); // Tworzenie brusha o kolorze ta listy "Resident modules"
 hBut0 = CreateWindow("BUTTON", "Open...", WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_NOTIFY, 10, 10, 90, 25, hwnd, ID_OPEN, hInst, 0);
 SendMessage(hBut0, WM_SETFONT, hFont, 0);
 hTemp = hBut0;
 hBut2 = CreateWindow("BUTTON", "Close", WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_NOTIFY | WS_DISABLED, 10, 40, 90, 25, hwnd, ID_CLOSE, hInst, 0);
 SendMessage(hBut2, WM_SETFONT, hFont, 0);
 hBut1 = CreateWindow("BUTTON", "Save report...", WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_NOTIFY | WS_DISABLED, 10, 70, 90, 25, hwnd, ID_SAVE, hInst, 0);
 SendMessage(hBut1, WM_SETFONT, hFont, 0);
 hBut3 = CreateWindow("BUTTON", "Quit", WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_NOTIFY, 10, 100, 90, 25, hwnd, ID_QUIT, hInst, 0);
 SendMessage(hBut3, WM_SETFONT, hFont, 0);
// Grupa "Informations"
 hBut4 = CreateWindow("BUTTON", " Informations ", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 116, 22, 323, 98, hwnd, 0, hInst, 0);
 SendMessage(hBut4, WM_SETFONT, hFont, 0);
 hWin0 = CreateWindow("STATIC", sver, WS_CHILD | WS_VISIBLE, 126, 42, 272, 67, hwnd, 0, hInst, 0);
 SendMessage(hWin0, WM_SETFONT, hFont, 0);
 hWin3 = CreateWindow("STATIC", "", WS_CHILD | WS_VISIBLE | SS_ICON, 399, 52, 32, 32, hwnd, 0, hInst, 0);
 hIcon = LoadIcon(0, IDI_INFORMATION); // Wczytanie ikony informacji systemu Windows
 SendMessage(hWin3, STM_SETIMAGE, 1, hIcon); // Wywietlenie wczytanej ikony
// Lista "Resident modules"
 hWin1 = CreateWindow("STATIC", stm1, WS_CHILD | WS_VISIBLE | WS_DISABLED, 10, 140, 120, 17, hwnd, 0, hInst, 0);
 SendMessage(hWin1, WM_SETFONT, hFont, 0);
 hLis0 = CreateWindow("LISTBOX", "", WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_DLGFRAME | WS_VSCROLL | WS_DISABLED | LBS_DISABLENOSCROLL | LBS_NOTIFY, 10, 158, 429, 180, hwnd, ID_LIST, hInst, 0);
 SendMessage(hLis0, WM_SETFONT, hFont, 0);
// Grupa "Selected module"
 hBut5 = CreateWindow("BUTTON", " Selected module ", WS_CHILD | WS_VISIBLE | BS_GROUPBOX | WS_DISABLED, 10, 338, 429, 105, hwnd, 0, hInst, 0);
 SendMessage(hBut5, WM_SETFONT, hFont, 0);
 hWin2 = CreateWindow("STATIC", stm2, WS_CHILD | WS_VISIBLE | WS_DISABLED, 20, 358, 410, 52, hwnd, 0, hInst, 0);
 SendMessage(hWin2, WM_SETFONT, hFont, 0);
 hBut6 = CreateWindow("BUTTON", "Extract...", WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_NOTIFY | WS_DISABLED, 180, 410, 90, 25, hwnd, ID_EXTR, hInst, 0);
 SendMessage(hBut6, WM_SETFONT, hFont, 0);
 break;
 
// Obsuga odbieranych rozkazw
 case WM_COMMAND:
 switch(HIWORD(wParam))
  {
  case 0:
  switch(LOWORD(wParam))
   {
// Wybranie przycisku "Open..."
   case ID_OPEN:
   if(FileSelect(0)) // Wskazano plik w oknie wyboru do odczytu
Y:  {ksam = 0; // Znacznik podwersji Kickstartu
     ks1m = 0; // Znacznik Kickstartu o rozmiarze 1MB
     ksar = 0; // Znacznik Kickstartu AROS
     hFile = CreateFile(fnam, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0, 0);
     if(hFile==INVALID_HANDLE_VALUE) // Nie mona otworzy pliku do odczytu
      {sprintf(smsg, "\nCan't open this file for read%s", stm3);
A:     SendMessage(hWin0, WM_SETTEXT, 0, smsg); // Wywietlenie informacji o bdzie
       hIcon = LoadIcon(0, IDI_ERROR); // Wczytanie ikony bdu systemu Windows
       SendMessage(hWin3, STM_SETIMAGE, 1, hIcon); // Wywietlenie wczytanej ikony
       break;}
     fsil = GetFileSize(hFile, &fsih);
     if(fsih) // Rozmiar pliku >4294967295 bajtw
B:    {sprintf(smsg, "\nWrong size of file.\nOnly 256/512kB/1MB Kickstarts are supported.");
C:     CloseHandle(hFile); // Zamknicie otwartego pliku
       goto A;}
     if(fsil!=262144 && fsil!=524288)
      {if(fsil==1048576) ks1m = 1; else goto B;} // Nieprawidowy rozmiar pliku
     mBuf = GlobalAlloc(GMEM_FIXED, fsil); // Rezerwowanie pamici na Kickstart
     if(!mBuf) // Nie mona zarezerwowa pamici
      {sprintf(smsg, "\nCan't allocate memory.\nFree some memory (close programs).");
       goto C;}
     if(!ReadFile(hFile, mBuf, fsil, &fsih, 0)) // Nie mona odczyta danych z pliku
D:    {sprintf(smsg, "\nCan't read data from%s", stm4);
       GlobalFree(mBuf); // Oddanie zarezerwowanej pamici
       goto C;}
     if(fsil!=fsih) goto D; // Nie odczytano caego pliku
     CloseHandle(hFile); // Zamknicie otwartego pliku
// Sprawdzanie wersji Kickstartu (bajty 12-19)
     if(ks1m) fsih = 524300; else fsih = 12;
     for(csel=0; csel<70; csel=csel+1)
      {if(!memcmp(mBuf+fsih, &tst[csel*2], 8)) break;}
     if(csel==70 && ks1m==0) // Nie rozpoznano wersji Kickstartu
      {sprintf(smsg, "\nUnknown Kickstart version (bytes 12-19)%s", stm6);
E:     GlobalFree(mBuf); // Oddanie zarezerwowanej pamici
       goto A;}
// Odczyt sumy kontrolnej Kickstartu
     memcpy(&fsih, mBuf+(fsil-24), 4); // 32-bitowe sowo korygujce sum kontroln
     fsih = SWAP32(fsih);
// Sprawdzanie sygnatury Kickstartu (pierwsze 4-bajty)
     memcpy(&ftmp, mBuf, 4);
     if(ftmp!=0xF94E1111 && ftmp!=0xF94E1411) // Nieprawidowa sygnatura (zapis w systemie Little-Endian)
      {if(ftmp==0xF94E0911 && ks1m==1); // Prawidowa sygnatura Kickstartu 1MB
       else
        {if(ftmp==0xF94E1611 && csel==24 && fsih==0x89D49334 && fsil==524288) ksam = 1; // Prawidowa sygnatura zmodyfikowanego Kickstartu 3.1 beta (40.62) dla A600
         else
          {if(ftmp==0xF94E1611 && csel==26 && (fsih==0xAE733766 || fsih==0xDB4247E0) && fsil==524288) ksam = 1; // Prawidowa sygnatura Kickstartu 3.1 beta (40.68) dla A600
           else
            {if(ftmp==0xF94E1611 && csel==27 && fsih==0x356714E3 && fsil==524288) ksam = 2; // Prawidowa sygnatura zmodyfikowanego Kickstartu 3.1 beta (40.70) dla A600
             else
              {if(ftmp==0xF94E1611 && csel==48 && fsih==0xB6B3E987 && fsil==524288) ksam = 1; // Prawidowa sygnatura Kickstartu 3.1 beta (40.3) dla A600
               else
                {if(ftmp==0x7C601111 && (csel==55 || csel==56 || csel==57 || csel==58) && fsil==262144); // Prawidowa sygnatura Kickstartu CDTV-CR extended 3.32/3.34/3.40/3.44
                 else
                  {if(ftmp==0xF94E1611 && csel==65 && fsih==0x9B03BEC9 && fsil==524288) ksam = 2; // Prawidowa sygnatura Kickstartu 3.1 beta (40.71) dla A2000
                   else
                    {sprintf(smsg, "\nWrong Kickstart signature (bytes 0-3)%s", stm5);
                     goto E;}}}}}}}}
// Sprawdzanie znacznika Kickstartu (bajty 8-11)
     memcpy(&ftmp, mBuf+8, 4);
     if(ftmp!=0xFFFF0000) // Nieprawidowy znacznik (zapis w systemie Little-Endian)
      {if((ftmp==0xDAD6E5A1 || ftmp==0x83781611) && csel==4 && fsih==0x56F2E2A6 && fsil==262144) ksam = 1; // Prawidowy znacznik zmodyfikowanego Kickstartu 1.2 (33.180) dla A500/1000/2000
       else
        {if(ftmp==0xCA3D8AD6 && csel==5 && (fsih==0x15267DB3 || fsih==0x524A9693) && fsil==262144) ksam = 1; // Prawidowy znacznik zmodyfikowanego Kickstartu 1.3 (34.5) dla A500/1000/2000
         else
          {sprintf(smsg, "\nWrong Kickstart mark (bytes 8-11)%s", stm5);
           goto E;}}}
// Rozrnianie wersji NTSC i PAL Kickstartu 1.1 (31.34)
     if(csel==2 && ks1m==0)
      {if(fsih==0x3A284FF8) // Wersja NTSC
        {yea[2] = 1985;
         ami[2] = "1000 NTSC";}
       else
        {if(fsih==0xCA71F279) // Wersja PAL
          {yea[2] = 1986;
           ami[2] = "1000 PAL";}
         else // Nieprawidowa warto sowa korygujcego sum kontroln
W:        {sprintf(smsg, "\nBad checksum (%08X) for this version%s", fsih, stm6);
           goto E;}}}
// Rozrnianie wersji Kickstartu 1.2 (33.180) dla Amig 500/1000/2000
     if(csel==4 && ks1m==0)
      {inf[4] = "";
       mod[4] = 22;
       yea[4] = 1986;
       if(fsih==0x56F2E2A6 && ksam==0); // Wersja dla A500/1000/2000
       else
        {if(ksam==1) // Wersja zmodyfikowana antywirusem Guardian 1.1/1.2 dla A500/1000/2000
          {yea[4] = 1988;
           inf[4] = "(hack Guardian 1.1 antivirus)";
           if(ftmp==0x83781611) // Wersja zmodyfikowana antywirusem Guardian 1.2
            {mod[4] = 21;
             inf[4] = "(hack Guardian 1.2 antivirus)";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 1.3 (34.5) dla Amig 500/1000/2000/CDTV i 3000
     if(csel==5 && ks1m==0)
      {inf[5] = "";
       mod[5] = 23;
       yea[5] = 1987;
       if(fsih==0x15267DB3 && ksam==0) ami[5] = "500/1000/2000/CDTV"; // Wersja dla A500/1000/2000/CDTV
       else
        {if(fsih==0x150B7DB3) ami[5] = "3000"; // Wersja dla A3000
         else
          {if(ksam==1) // Wersja zmodyfikowana antywirusem Guardian 1.2 dla A500/1000/2000
            {mod[5] = 21;
             yea[5] = 1988;
             ami[5] = "500/1000/2000";
             inf[5] = "(hack Guardian 1.2 antivirus RAM)";
             if(fsih==0x15267DB3) // Wersja bootujca z dyskietki
              {mod[5] = 22;
               inf[5] = "(hack Guardian 1.2 antivirus FDD)";}}
           else goto W;}}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji prawidowej i uszkodzonej Kickstartu 2.01 (36.141)
     if(csel==11 && ks1m==0)
      {if(fsih==0xECEED72A) inf[11] = ""; // Wersja prawidowa
       else
        {if(fsih==0x3FF72879) inf[11] = "(bad)"; // Wersja uszkodzona
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 2.04 [pre] (37.175) dla Amig 500/2000 i 3000
     if(csel==15 && ks1m==0)
      {mod[15] = 39;
       ver[15] = "2.04 (37.175)";
       ami[15] = "500/2000";
       cpu[15] = 0;
       if(fsih==0x000B927C); // Wersja dla A500/2000
       else
        {if(fsih==0x54876DAB) // Wersja dla A3000
          {mod[15] = 41;
           ami[15] = "3000";
           cpu[15] = 4;}
         else
          {if(fsih==0x73B3210E) // Wersja przedpremierowa dla A500/2000
            {ksam = 1;
             ver[15] = "2.04 pre (37.175)";}
           else goto W;}}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji zwykej i Plus Kickstartu 2.04 (37.210)
     if(csel==16 && ks1m==0)
      {if(fsih==0x2A0F15A9) // Wersja zwyka
        {inf[16] = "";
         ver[16] = "2.04 (37.210)";}
       else
        {if(fsih==0xE66F399A) // Wersja zmodyfikowana Plus
          {inf[16] = "(hack)";
           ver[16] = "2.04 Plus (37.210)";}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.0 (39.106) dla Amig 1200/4000
     if(csel==21 && ks1m==0)
      {if(fsih==0x8B56E930) // Wersja dla A1200
        {mod[21] = 42;
         ami[21] = "1200";
         cpu[21] = 0;}
       else
        {if(fsih==0x3E3BB5E7) // Wersja dla A4000
          {mod[21] = 41;
           ami[21] = "4000";
           cpu[21] = 2;}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 (40.55) dla Amig 3000/4000
     if(csel==22 && ks1m==0)
      {inf[22] = "";
       ami[22] = "3000";
       cpu[22] = 4;
       if(fsih==0x97DC36A2); // Wersja dla A3000
       else
        {if(fsih==0x97DBEAA2) inf[22] = "(hack ShapeShifter emulator)"; // Wersja zmodyfikowana pod emulator dla A3000
         else
          {if(fsih==0xF90A56C0) // Wersja zmodyfikowana dla A4000
            {inf[22] = "(hack)";
             ami[22] = "4000";
             cpu[22] = 2;}
           else goto W;}}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 [beta] (40.62) dla Amig 600/3000
     if(csel==24 && ks1m==0)
      {if(ksam==1) // Wersja zmodyfikowana dla A600
        {mod[24] = 42;
         ami[24] = "600";
         ver[24] = "3.1 beta (40.62)";
         cpu[24] = 0;}
       else
        {if(fsih==0x0CC4ABE0) // Wersja zmodyfikowana dla A3000
          {mod[24] = 41;
           ami[24] = "3000";
           ver[24] = "3.1 (40.62)";
           cpu[24] = 4;}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji zwykej i zmodyfikowanej Kickstartu 3.1 (40.63)
     if(csel==25 && ks1m==0)
      {if(fsih==0x9FDEEEF6) inf[25] = ""; // Wersja zwyka
       else
        {if(fsih==0x9FDEA2F6) inf[25] = "(hack ShapeShifter emulator)"; // Wersja zmodyfikowana pod emulator
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 [beta] (40.68) dla Amig 600/1200/3000/4000
     if(csel==26 && ks1m==0)
      {inf[26] = "";
       ver[26] = "3.1 (40.68)";
       cpu[26] = 0;
       if(ksam==1 || fsih==0x87BA7A3E || fsih==0x87BA2E3E) // Wersja dla A600/1200 lub zmodyfikowana dla A600/1200
        {mod[26] = 42;
         if(ksam==1)
          {ami[26] = "600";
           ver[26] = "3.1 beta (40.68)";
           if(fsih==0xDB4247E0) inf[26] = "(hack)";}
         else
          {ami[26] = "1200";
           cpu[26] = 1;
           if(fsih==0x87BA2E3E) inf[26] = "(hack ShapeShifter emulator)";}}
       else
        {if(fsih==0x8F4C0C67 || fsih==0x45C3145E || fsih==0x44C3115E || fsih==0xF9C3145D) // Wersja dla A3000/4000 lub zmodyfikowana dla A4000
          {mod[26] = 41;
           ami[26] = "4000";
           cpu[26] = 2;
           if(fsih==0x8F4C0C67)
            {ami[26] = "3000";
             cpu[26] = 4;}
           if(fsih==0x44C3115E) inf[26] = "(hack Cloanto emulator)"; // Wersja zmodyfikowana pod emulator dla A4000
           if(fsih==0xF9C3145D) inf[26] = "(hack ShapeShifter emulator)";} // Wersja zmodyfikowana pod emulator dla A4000
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 [beta] (40.70) dla Amig 600/3000/4000/4000T
     if(csel==27 && ks1m==0)
      {inf[27] = "";
       ver[27] = "3.1 (40.70)";
       cpu[27] = 0;
       if(fsih!=0xA580A2DE && fsih!=0x47BCEC13) inf[27] = "(hack)"; // Wersja zmodyfikowana dla A600/3000/4000
       if(fsih==0x960F9194) inf[27] = "(hack ShapeShifter emulator)"; // Wersja zmodyfikowana pod emulator dla A4000
       if(ksam==2) // Wersja zmodyfikowana dla A600
        {mod[27] = 42;
         ami[27] = "600";
         ver[27] = "3.1 beta (40.70)";}
       else
        {if(fsih==0xA580A2DE || fsih==0x47BCEC13 || fsih==0x4E5728D3 || fsih==0xE20F9194 || fsih==0x960F9194) // Wersja zwyka dla A4000/4000T lub zmodyfikowana dla A3000/4000
          {mod[27] = 41;
           ami[27] = "4000";
           cpu[27] = 2;
           if(fsih==0x4E5728D3)
            {ami[27] = "3000";
             cpu[27] = 4;}
           if(fsih==0x47BCEC13)
            {ksam = 1;
             mod[27] = 42;
             ami[27] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu extended 0.9 beta/1.0 beta/1.0 (34.1001) dla Amigi CDTV
     if(csel==30 && ks1m==0)
      {ver[30] = "CDTV extended 1.0 (34.1001)";
       if(!memcmp(mBuf+18436, "cdtv 35.2 (6.2.91)", 18)) ver[30] = "CDTV extended 0.9 beta";
       if(!memcmp(mBuf+18598, "cdtv 35.7 (6.3.91)", 18)) ver[30] = "CDTV extended 1.0 beta";}
// Rozrnianie wersji Kickstartu extended 2.30 (37.201) dla Amigi CDTV i napdu CD A570
     if(csel==32 && ks1m==0)
      {inf[32] = "";
       yea[32] = 1992;
       ami[32] = "CDTV";
       ver[32] = "CDTV extended 2.30 (37.201)";
       if(fsih==0x7AB01A03); // Wersja dla ACDTV
       else
        {if(fsih==0x5E0C8CB8) // Wersja zmodyfikowana dla ACDTV
          {yea[32] = 2013;
           inf[32] = "(hack)";}
         else
          {if(fsih==0x94FEF2C2) // Wersja dla A570 CD
            {ami[32] = "A570";
             ver[32] = "A570 extended 2.30 (37.201)";}
           else goto W;}}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.x (45.61) dla Amig 600/1200/3000/4000/4000T
     if(csel==36 && ks1m==0)
      {if(fsih==0x6A726C2D || fsih==0x74E824A9) // Wersja dla A600/1200
        {mod[36] = 42;
         ami[36] = "500/600/2000";
         cpu[36] = 0;
         if(fsih==0x74E824A9)
          {ami[36] = "1200";
           cpu[36] = 1;}}
       else
        {if(fsih==0xBB82B9EA || fsih==0xE6DA4C32 || fsih==0x6078EA6C) // Wersja dla A3000/4000/4000T
          {mod[36] = 41;
           ami[36] = "4000";
           cpu[36] = 2;
           if(fsih==0xBB82B9EA)
            {ami[36] = "3000";
             cpu[36] = 4;}
           if(fsih==0x6078EA6C)
            {mod[36] = 42;
             ami[36] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 (40.72) dla Amig 600/1200/3000/4000/4000T
     if(csel==37 && ks1m==0)
      {if(fsih==0x384B9020 || fsih==0x86577700) // Wersja dla A600/1200
        {mod[37] = 42;
         ami[37] = "500/600/2000";
         cpu[37] = 0;
         if(fsih==0x86577700)
          {ami[37] = "1200";
           cpu[37] = 1;}}
       else
        {if(fsih==0xE6F41CEE || fsih==0x487E030C || fsih==0xA2358473) // Wersja dla A3000/4000/4000T
          {mod[37] = 41;
           ami[37] = "4000";
           cpu[37] = 2;
           if(fsih==0xE6F41CEE)
            {ami[37] = "3000";
             cpu[37] = 4;}
           if(fsih==0xA2358473)
            {ksam = 1;
             mod[37] = 42;
             ami[37] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln



// Rozrnianie wersji Kickstartu 3.x (45.62) dla Amig 1200/3000/4000
// Aktualnie ten Kickstart jest tylko czciowo obsugiwany.
     if(csel==38 && ks1m==0)
      {if(fsih==0x74E214A2) // Wersja dla A1200
        {mod[38] = 42;
         ami[38] = "1200";
         cpu[38] = 1;}
       else
        {if(fsih==0xBB7FA9E3 || fsih==0xE6D43C2B) // Wersja dla A3000/4000
          {mod[38] = 41;
           ami[38] = "4000";
           cpu[38] = 2;
           if(fsih==0xBB7FA9E3)
            {ami[38] = "3000";
             cpu[38] = 4;}}
         else // Nieznana warto sowa korygujcego sum kontroln
          {sprintf(smsg, "\nUnknown Kickstart version (bytes 12-19)%s", stm6);
           goto E;}}}



// Rozrnianie wersji Kickstartu 3.x (45.64) dla Amig 600/1200/3000/4000/4000T
     if(csel==39 && ks1m==0)
      {if(fsih==0x40DC9858 || fsih==0x4B5250D4) // Wersja dla A600/1200
        {mod[39] = 42;
         ami[39] = "500/600/2000";
         cpu[39] = 0;
         if(fsih==0x4B5250D4)
          {ami[39] = "1200";
           cpu[39] = 1;}}
       else
        {if(fsih==0x91F7E605 || fsih==0xBD187881 || fsih==0x36B716BB) // Wersja dla A3000/4000/4000T
          {mod[39] = 41;
           ami[39] = "4000";
           cpu[39] = 2;
           if(fsih==0x91F7E605)
            {ami[39] = "3000";
             cpu[39] = 4;}
           if(fsih==0x36B716BB)
            {mod[39] = 42;
             ami[39] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
/* Rozrnianie wersji Kickstartu 3.1.4 (46.143) [v2] dla Amig 600/1200/2000/3000/4000/4000T
   Istniej dwie odmiany Kickstartu 3.1.4 (46.143): pierwsza/starsza i druga/nowsza (oznaczona jako "v2"),
   ktra pojawia si ok. miesic pniej i rni si jedynie zmienion treci komunikatu o prawach autorskich.
   Aktualnie druga/nowsza odmiana jest tylko czciowo obsugiwana. */
     if(csel==41 && ks1m==0)
      {ver[41] = "3.1.4 (46.143)";
       if(fsih==0xBE662BCF || fsih==0x39DD0DD3 || fsih==0x1A9EF24E || fsih==0x48415049 || fsih==0x863C04A1) ver[41] = "3.1.4 (46.143) v2"; // Wersja v2
       if(fsih==0x40674914 || fsih==0xBBDE2B17 || fsih==0x92E13716 || // Wersja dla A600/1200/2000
          fsih==0xBE662BCF || fsih==0x39DD0DD3)                       // Wersja v2 dla A600/1200
        {mod[41] = 42;
         ami[41] = "500/600/2000";
         cpu[41] = 0;
         if(fsih==0x92E13716)
          {mod[41] = 36;
           ami[41] = "2000";}
         if(fsih==0xBBDE2B17 || fsih==0x39DD0DD3)
          {ami[41] = "1200";
           cpu[41] = 1;}}
       else
        {if(fsih==0xDD0F876A || fsih==0xDB4414D3 || fsih==0x223EDFAC || // Wersja dla A3000/4000/4000T
            fsih==0x1A9EF24E || fsih==0x48415049 || fsih==0x863C04A1)   // Wersja v2 dla A3000/4000/4000T
          {mod[41] = 41;
           ami[41] = "4000";
           cpu[41] = 2;
           if(fsih==0xDD0F876A || fsih==0x1A9EF24E)
            {ami[41] = "3000";
             cpu[41] = 4;}
           if(fsih==0x223EDFAC || fsih==0x863C04A1)
            {mod[41] = 42;
             ami[41] = "4000T";}}
         else // Nieznana warto sowa korygujcego sum kontroln
          {sprintf(smsg, "\nUnknown Kickstart version (bytes 12-19)%s", stm6);
           goto E;}}}
         //else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.2 (47.96) dla Amig 600/1200/3000/4000/4000T
     if(csel==42 && ks1m==0)
      {if(fsih==0x035D98F3 || fsih==0xE3B7D1D5) // Wersja dla A600/1200
        {mod[42] = 44;
         ami[42] = "500/600/2000/CDTV";
         cpu[42] = 0;
         if(fsih==0xE3B7D1D5)
          {ami[42] = "1200";
           cpu[42] = 1;}}
       else
        {if(fsih==0x2A977A67 || fsih==0x6D8C7641 || fsih==0xD3D65F45) // Wersja dla A3000/4000/4000T
          {mod[42] = 43;
           ami[42] = "4000";
           cpu[42] = 2;
           if(fsih==0x2A977A67)
            {ami[42] = "3000";
             cpu[42] = 4;}
           if(fsih==0xD3D65F45)
            {mod[42] = 44;
             ami[42] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.x (45.66) dla Amig 600/1200/3000/4000/4000T
     if(csel==45 && ks1m==0)
      {if(fsih==0x4DB45B1A || fsih==0x95A124D9) // Wersja dla A600/1200
        {mod[45] = 42;
         ami[45] = "500/600/2000";
         cpu[45] = 0;
         if(fsih==0x95A124D9)
          {ami[45] = "1200";
           cpu[45] = 1;}}
       else
        {if(fsih==0xDB22DCC3 || fsih==0x288F19C4 || fsih==0xE46E466D) // Wersja dla A3000/4000/4000T
          {mod[45] = 41;
           ami[45] = "4000";
           cpu[45] = 2;
           if(fsih==0xDB22DCC3)
            {ami[45] = "3000";
             cpu[45] = 4;}
           if(fsih==0xE46E466D)
            {mod[45] = 42;
             ami[45] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.2 (47.102) dla Amig 600/1200/3000/4000/4000T
     if(csel==46 && ks1m==0)
      {if(fsih==0x4CB8FDD9 || fsih==0x7A47FC4D) // Wersja dla A600/1200
        {mod[46] = 44;
         ami[46] = "500/600/2000/CDTV";
         cpu[46] = 0;
         if(fsih==0x7A47FC4D)
          {ami[46] = "1200";
           cpu[46] = 1;}}
       else
        {if(fsih==0x4F2D267C || fsih==0xAF55C477 || fsih==0x96727F60) // Wersja dla A3000/4000/4000T
          {mod[46] = 43;
           ami[46] = "4000";
           cpu[46] = 2;
           if(fsih==0x4F2D267C)
            {ami[46] = "3000";
             cpu[46] = 4;}
           if(fsih==0x96727F60)
            {mod[46] = 44;
             ami[46] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 beta (40.3) dla Amig 600/4000
     if(csel==48 && ks1m==0)
      {if(ksam==1) // Wersja dla A600
        {mod[48] = 42;
         ami[48] = "600";
         cpu[48] = 0;}
       else
        {if(fsih==0x87F7C4FC) // Wersja dla A4000
          {mod[48] = 41;
           ami[48] = "4000";
           cpu[48] = 2;}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.2 (47.111) dla Amig 600/1200/3000/4000/4000T
     if(csel==52 && ks1m==0)
      {if(fsih==0xB1728E0A || fsih==0xDB198F9E) // Wersja dla A600/1200
        {mod[52] = 44;
         ami[52] = "500/600/2000/CDTV";
         cpu[52] = 0;
         if(fsih==0xDB198F9E)
          {ami[52] = "1200";
           cpu[52] = 1;}}
       else
        {if(fsih==0x70A81C49 || fsih==0xF5DB6EF7 || fsih==0x8359FFA4) // Wersja dla A3000/4000/4000T
          {mod[52] = 43;
           ami[52] = "4000";
           cpu[52] = 2;
           if(fsih==0x70A81C49)
            {ami[52] = "3000";
             cpu[52] = 4;}
           if(fsih==0x8359FFA4)
            {mod[52] = 44;
             ami[52] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu 3.1 [beta] (40.71) dla Amig 600/1200/2000/3000/4000/4000T
     if(csel==65 && ks1m==0)
      {ver[65] = "3.1 (40.71)";
       if(ksam==2) ver[65] = "3.1 beta (40.71)"; // Wersja beta dla A2000
       if(fsih==0x9AE015D2 || fsih==0xB4F81B4D || fsih==0xB5019F52 || ksam==2) // Wersja dla A600/1200/2000
        {mod[65] = 42;
         ami[65] = "500/600/2000";
         cpu[65] = 0;
         if(fsih==0xB5019F52 || ksam==2)
          {mod[65] = 39;
           ami[65] = "2000";}
         if(fsih==0xB4F81B4D)
          {ami[65] = "1200";
           cpu[65] = 1;}}
       else
        {if(fsih==0x135D9478 || fsih==0x08DB04B7 || fsih==0xF3DB1D8C) // Wersja dla A3000/4000/4000T
          {mod[65] = 41;
           ami[65] = "4000";
           cpu[65] = 2;
           if(fsih==0x135D9478)
            {ami[65] = "3000";
             cpu[65] = 4;}
           if(fsih==0xF3DB1D8C)
            {ksam = 1;
             mod[65] = 42;
             ami[65] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Rozrnianie wersji Kickstartu AROS ROM/EXT (46.10, 46.11, 46.12)
     if((csel==66 || csel==67 || csel==68) && ks1m==0)
      {ksar = 1;
       if(!memcmp(mBuf+29, "ROM", 3)) ami[csel] = "(ROM)";
       else
        {ksam = 1;
         ami[csel] = "(EXT)";}
       sprintf(smsg, "%s", "All Rights Reserved.");
       tpos = FindData(mBuf, 140, smsg, 20);
       if(!tpos) yea[csel] = 2011;
       else
        {memcpy(&stmy, tpos+27, 5);
         yea[csel] = atoi(stmy);}}
// Rozrnianie wersji Kickstartu 3.2 (47.115) dla Amig 600/1200/3000/4000/4000T
     if(csel==69 && ks1m==0)
      {if(fsih==0x7032217B || fsih==0x47195861) // Wersja dla A600/1200
        {mod[69] = 44;
         ami[69] = "500/600/2000/CDTV";
         cpu[69] = 0;
         if(fsih==0x47195861)
          {ami[69] = "1200";
           cpu[69] = 1;}}
       else
        {if(fsih==0xE05EF3A0 || fsih==0x0EFA7FD5 || fsih==0x1E1D6069) // Wersja dla A3000/4000/4000T
          {mod[69] = 43;
           ami[69] = "4000";
           cpu[69] = 2;
           if(fsih==0xE05EF3A0)
            {ami[69] = "3000";
             cpu[69] = 4;}
           if(fsih==0x1E1D6069)
            {mod[69] = 44;
             ami[69] = "4000T";}}
         else goto W;}} // Nieprawidowa warto sowa korygujcego sum kontroln
// Szukanie pierwszego znacznika (0x4AFC) moduu rezydentnego (Resident Module Tag) w Kickstarcie
     sprintf(smsg, "%c%c%c", 0x4A, 0xFC, 0x00);
     tpos = FindData(mBuf, fsil, smsg, 3); // Szukanie znacznika (Match Word)
     if(!tpos) // Nie znaleziono adnego znacznika (brak moduw rezydentnych)
      {sprintf(smsg, "\nResident modules not found%s", stm5);
       goto E;}
     if(fsil-(tpos-mBuf)<26) // Zbyt krtka struktura znacznika (mniej ni 26 bajtw)
F:    {sprintf(smsg, "\nToo short resident module tag%s", stm5);
       goto E;}
// Odczyt i weryfikacja bazowego adresu Kickstartu w pierwszym module rezydentnym
     memcpy(&base, tpos+2, 2);
     base = SWAP16(base);
     if(fsil==262144) // Kickstart o rozmiarze 256kB
      {if(csel<30 || csel==50) // Kickstart 0.7, 1.0, 1.1 (31.34) PAL/NTSC, 1.2 (33.166), 1.2 (33.180), 1.2.1 (34.4), 1.3 (34.5), 1.4 alpha 15 (36.15)
        {if(base!=0xFC) // Nieprawidowy adres bazowy
G:        {sprintf(smsg, "Invalid Kickstart base address%s%06X", stm8, tpos+2-mBuf);
           goto E;}}
       else // Kickstart CDTV extended 0.1/0.9/1.0 beta, CDTV extended 1.0 (34.1001), CDTV extended 2.7 (37.201), CDTV extended 2.30 (37.201), CDTV extended 2.35 (37.201), CDTV extended 3.2 (37.202), CDTV-CR extended 3.32/3.34/3.40/3.44
        {if(base!=0xF0) goto G;}} // Nieprawidowy adres bazowy
     else
      {if(!ks1m) // Kickstart o rozmiarze 512kB
        {if(csel==33 || csel==53 || (csel==66 && ksam==1) || (csel==67 && ksam==1)) // Kickstart CD32 extended 3.1 (40.16), CD32 extended 3.1 (40.60), AROS EXT (46.10), AROS EXT (46.11)
          {if(base!=0xE0) goto G;} // Nieprawidowy adres bazowy
         else
          {if(csel==8 || csel==10 || csel==14 || (csel==15 && ksam==1) || csel==16 || (csel==24 && ksam==1) || (csel==26 && ksam==1) || (csel==27 && ksam==2) || (csel==48 && ksam==1) || csel==59 || csel==64) // Kickstart 1.4 alpha 18 (36.2), 1.4 beta (36.3), 2.0 beta (36.67), 2.03 (37.74), 2.03 (37.92), 2.04 pre (37.175), 2.04 [Plus] (37.210), 3.1 beta (40.62), 3.1 beta (40.68), 3.1 beta (40.70), 3.1 beta (40.3)
            {if(base!=0x20) goto G;} // Nieprawidowy adres bazowy
           else
            {if(csel==60) // Kickstart 2.0 beta (36.65)
              {if(base!=0xC0) goto G;} // Nieprawidowy adres bazowy
             else
              {if(csel==61) // Kickstart 2.0 beta (36.72)
                {if(base!=0xF0) goto G;} // Nieprawidowy adres bazowy
               else // Pozostae Kickstarty
                {if(base!=0xF8) goto G;}}}}} // Nieprawidowy adres bazowy
       else // Kickstart o rozmiarze 1MB
        {if(base!=0xE0) goto G;}} // Nieprawidowy adres bazowy
     base = base<<16; // Bazowy adres Kickstartu
// Wyszukiwanie wszystkich znacznikw i generowanie listy moduw rezydentnych w Kickstarcie
     mnum = -1;
     tBuf = mBuf;
     ftmp = fsil;
     skip = ktm2 = 0;
     while(1)
      {tpos = FindData(tBuf, ftmp, smsg, 3); // Szukanie znacznika moduu rezydentnego (Match Word)
       if(!tpos) break; // Nie znaleziono znacznika (przerwanie ptli)
       if(fsil-(tpos-mBuf)+ktm2<26) goto F; // Zbyt krtka struktura znacznika (mniej ni 26 bajtw)
       mnum = mnum+1; // Liczba moduw rezydentnych w Kickstarcie
       if(mnum>44 && ks1m==0 && ksar==0) // Zbyt duo moduw (maksymalnie 45)
        {sprintf(smsg, "\nToo many resident modules (max 45)%s", stm6);
         goto E;}
       if(mnum>69 && (ks1m==1 || ksar==1)) // Zbyt duo moduw w Kickstarcie 1MB lub AROS (maksymalnie 70)
        {sprintf(smsg, "\nToo many resident modules (max 70).\nThis limit can be enlarged.");
         goto E;}
       if((tpos-mBuf)-ktm2>524287) // Przejcie do drugiej poowy Kickstartu 1MB
        {base = 0xF80000;
         fsil = ktm2 = 524288;}
// Odczyt i weryfikacja adresu wskazujcego na pocztek aktualnego moduu (Match Tag)
       memcpy(&fsih, tpos+2, 4);
       fsih = SWAP32(fsih);
       if(fsih<=base || fsih>base+fsil-1 || tpos!=(fsih-base)+mBuf+ktm2) // Nieprawidowy adres
        {if((csel<7 || csel==33 || csel==50 || csel==53) && ks1m==0) // Kickstart 0.7, 1.0, 1.1 (31.34) PAL/NTSC, 1.2 (33.166), 1.2 (33.180), 1.2.1 (34.4), 1.3 (34.5), 1.4 alpha 15 (36.15), CD32 extended 3.1 (40.16), CD32 extended 3.1 (40.60)
          {if(csel==0 && (mnum==16 || mnum==22)) goto H; // Pominicie bdnego znacznika w Kickstarcie 0.7
           if(csel==1 && (mnum==14 || mnum==21)) goto H; // Pominicie bdnego znacznika w Kickstarcie 1.0
           if(csel==2 && mnum==21) goto H; // Pominicie bdnego znacznika w Kickstarcie 1.1 (31.34) PAL/NTSC
           if((csel==3 || csel==4) && mnum==22 && ksam==0) goto H; // Pominicie bdnego znacznika w Kickstarcie 1.2 (33.166), 1.2 (33.180)
           if((csel==4 || csel==5) && (mnum==21 || mnum==22) && ksam==1) goto H; // Pominicie bdnego znacznika w zmodyfikowanym Kickstarcie 1.2 (33.180)/1.3 (34.5) dla A500/1000/2000
           if((csel==5 || csel==50) && (mnum==22 || mnum==23) && ksam==0) goto H; // Pominicie bdnego znacznika w Kickstarcie 1.2.1 (34.4), 1.3 (34.5)
           if(csel==6 && mnum==22) goto H; // Pominicie bdnego znacznika w Kickstarcie 1.4 alpha 15 (36.15)
           if((csel==33 || csel==53) && (mnum==2 || mnum==3)) goto H;} // Pominicie bdnego znacznika w Kickstarcie CD32 extended 3.1 (40.16), CD32 extended 3.1 (40.60)
         if(csel==54 && mnum==3 && ks1m==0) goto H; // Pominicie bdnego znacznika w Kickstarcie CDTV extended 0.1 beta
         if(fsih<=base && csel==66 && mnum==7 && ksam==1) goto H; // Pominicie bdnego znacznika w Kickstarcie AROS EXT (46.10)
         if(tpos!=(fsih-base)+mBuf && csel==67 && mnum==19 && ksam==1) goto H; // Pominicie bdnego znacznika w Kickstarcie AROS EXT (46.11) [2022-01-26]
         /* W wyej wymienionych oryginalnych wersjach Kickstaru, znajduj si bdne znaczniki moduw rezydentnych.
            Maj one nieprawidowy adres pocztku moduu oraz wystpuj tylko przed moduami, o okrelonych numerach.
            Dziki temu program moe je pomija, co pozwala na wykrycie wszystkich prawidowych znacznikw moduw. */


//sprintf(stmp, "%u", strlen(stmp));
//SendMessage(hWin1, WM_SETTEXT, 0, stmp);
//MessageBox(0, stmp, "Info", 0);
//sprintf(smsg, "%sstart address%s%06X %u", stm7, stm8, tpos+2-mBuf, mnum);


         sprintf(smsg, "%sstart address%s%06X", stm7, stm8, tpos+2-mBuf);
         goto E;
H:       skip = 1;
         mnum = mnum-1;
         tBuf = tpos+1;
         ftmp = fsil-1;
         continue;}
       skip = 0;
       madr[mnum] = tpos;
       tadr[mnum] = base+(tpos-mBuf)-ktm2;
// Odczyt i weryfikacja adresu do kontynuowania wyszukiwania z aktualnego moduu (End Skip)
       memcpy(&fsih, tpos+6, 4);
       fsih = SWAP32(fsih);
       if(fsih<=base || fsih>base+fsil-1 || tpos+26>(fsih-base)+mBuf+ktm2) // Nieprawidowy adres
        {if((fsih-base)<=(tpos-mBuf) && ksar==1) fsih = (tpos-mBuf)+base+1; // Pominicie nieprawidowego adresu do kontynuowania wyszukiwania w Kickstarcie AROS
         else
          {sprintf(smsg, "%scontinue scan address%s%06X", stm7, stm8, tpos+6-mBuf);
           goto E;}}
       tBuf = mend[mnum] = (fsih-base)+mBuf+ktm2;
       ftmp = fsil-(fsih-base);
// Odczyt typu aktualnego moduu (Type of Module)
       memcpy(&mtyp[mnum], tpos+12, 1);
// Odczyt priorytetu inicjalizacji aktualnego moduu (Initialization Priority)
       memcpy(&mpri[mnum], tpos+13, 1);
// Odczyt i weryfikacja adresu wskazujcego na cig ASCIIZ z nazw aktualnego moduu (Node Name)
       memcpy(&fsih, tpos+14, 4);
       fsih = SWAP32(fsih);
       if(fsih<=base || fsih>base+fsil-1) // Nieprawidowy adres
        {if(csel==30 && mnum==9 && fsih==0 && ks1m==0) // Zerowy adres do nazwy moduu "cdstrap 8.2 (9.3.91)" w Kickstarcie CDTV extended 1.0 (34.1001)
          {mnam[9][0] = 0;
           goto I;}
         if(csel==53 && mnum==7 && fsih==0 && ks1m==0) // Zerowy adres do nazwy moduu "ad_NonVolatile 40.20 (23.3.93)" w Kickstarcie CD32 extended 3.1 (40.16)
          {mnam[7][0] = 0;
           goto I;}
         if(csel==54 && mnum==6 && fsih==0 && ks1m==0) // Zerowy adres do nazwy moduu "cdstrap 4.1 (19 Sep 1990)" w Kickstarcie CDTV extended 0.1 beta
          {mnam[6][0] = 0;
           goto I;}
         sprintf(smsg, "%sname address%s%06X", stm7, stm8, tpos+14-mBuf);
         goto E;}
       if(!CheckString((fsih-base)+mBuf+ktm2, mnam[mnum], 32)) // Nieprawidowy cig z nazw moduu
        {sprintf(smsg, "%sname string%s%06X", stm7, stm8, fsih-base+ktm2);
         goto E;}
// Odczyt i weryfikacja adresu wskazujcego na cig ASCIIZ z wersj aktualnego moduu (Identification String)
I:     memcpy(&fsih, tpos+18, 4);
       fsih = SWAP32(fsih);
       if(fsih<=base || fsih>base+fsil-1) // Nieprawidowy adres
        {sprintf(smsg, "%sversion address%s%06X", stm7, stm8, tpos+18-mBuf);
         goto E;}
       if(!CheckString((fsih-base)+mBuf+ktm2, mver[mnum], 69)) // Nieprawidowy cig z wersj moduu
        {memcpy(&ctst, (fsih-base)+mBuf+ktm2, 1);
         if(csel==4 && mnum==18 && ctst[0]==155 && ksam==1) // Zbyt dugi cig z wersj moduu "strap" w zmodyfikowanym Kickstarcie 1.2 (33.180) dla Amig 500/1000/2000
          {strncpy(mver[18], (fsih-base)+mBuf+ktm2, 54);
           mver[18][54] = 0;
           goto J;}
         if((csel==4 || csel==5) && mnum==17 && ctst[0]==155 && ksam==1) // Zbyt dugi cig z wersj moduu "strap" w zmodyfikowanym Kickstarcie 1.2 (33.180)/1.3 (34.5) dla Amig 500/1000/2000
          {strncpy(mver[17], (fsih-base)+mBuf+ktm2, 55);
           mver[17][55] = 0;
           goto J;}
         if((csel==27 || csel==37 || csel==65) && mnum==7 && ctst[0]==0 && ksam==1) // Pusty cig z wersj moduu "NCR scsi.device" w Kickstarcie 3.1 (40.70, 40.71, 40.72) dla Amigi 4000T
          {mver[7][0] = 0;
           goto J;}
         sprintf(smsg, "%sversion string%s%06X", stm7, stm8, fsih-base+ktm2);
         goto E;}
// Odczyt i weryfikacja adresu wskazujcego na kod inicjalizujcy aktualny modu (Init Code)
J:     memcpy(&fsih, tpos+22, 4);
       fsih = SWAP32(fsih);
       if(fsih<=base || fsih>base+fsil-1) // Nieprawidowy adres
        {if((csel==1 || csel==2) && mnum==20 && fsih==0 && ks1m==0) continue; // Zerowy adres do kodu inicjalizujcego modu "workbench.task" w Kickstarcie 1.0, 1.1 (31.34) PAL/NTSC
         sprintf(smsg, "%sinit code address%s%06X", stm7, stm8, tpos+22-mBuf);
         goto E;}}
     if(skip) // Nie znaleziono prawidowego znacznika moduu po pominiciu bdnego
      {sprintf(smsg, "\nMissing valid resident module tag.\nMaybe image is corrupted.");
       goto E;}
     if(mnum!=mod[csel] && ks1m==0 && ksar==0) // Nieprawidowa liczba moduw
      {sprintf(smsg, "\nWrong number of resident modules%s", stm6);
       goto E;}
     load = 1; // Jest zarezerwowana pami do oddania z wczytanym obrazem Kickstartu
     DragAcceptFiles(hwnd, 0); // Wyczenie wrzucania obiektw do gwnego okna programu (drag&drop)
/* Obliczanie sumy kontrolnej Kickstartu (Checksum)
   Jest to suma wszystkich 32-bitowych sw Kickstartu oraz przepenie 32-bitowego licznika, ktre wystpiy podczas
   dodawania tych sw. Prawidowa warto obliczonej sumy kontrolnej, zawsze wynosi -1 ($FFFFFFFF). Wyjtkiem s
   Kickstarty CDTV extended 0.1/0.9/1.0 beta, CDTV extended 1.0 (34.1001), CDTV extended 2.7 (37.201) i CDTV extended
   3.2 (37.202), ktre nie maj prawidowej sumy kontrolnej. */
     ksum = skip = 0;
     for(fsih=0; fsih<fsil; fsih=fsih+4)
      {memcpy(&ftmp, mBuf+fsih+ktm2, 4);
       ftmp = SWAP32(ftmp); // Kolejne 32-bitowe sowo Kickstartu
       ktmp = ksum;
       ksum = ksum+ftmp; // Dodawanie wartoci kolejnego sowa
       if(ksum<ktmp) skip = skip+1;} // Wystpio przepenienie 32-bitowego licznika
     ksum = ksum+skip; // Obliczona suma kontrolna Kickstartu
// Odczyt 32-bitowego sowa, ktre koryguje sum kontroln Kickstartu tak, aby jej warto bya prawidowa
     memcpy(&fsih, mBuf+ktm2+(fsil-24), 4);
     fsih = SWAP32(fsih); // 32-bitowe sowo korygujce sum kontroln
// Wywietlanie informacji o otwartym Kickstarcie
     hIcon = LoadIcon(hInst, ID_ICON); // Wczytanie ikony Amigi (checkmark)
     if(ksum==-1) sprintf(smsg, "OK (%08X", fsih); // Prawidowa suma kontrolna Kickstartu
     else
      {if((csel==30 || csel==31 || csel==44 || csel==54) && ks1m==0) sprintf(smsg, "NONE (%08X", fsih); // Kickstart CDTV extended 0.1/0.9/1.0 beta, CDTV extended 1.0 (34.1001), CDTV extended 2.7 (37.201), CDTV extended 3.2 (37.202)
       else // Bdna suma kontrolna Kickstartu
        {sprintf(smsg, "BAD (%08X", fsih);
         hIcon = LoadIcon(0, IDI_ERROR);}} // Wczytanie ikony bdu systemu Windows
     if(ks1m) sprintf(stmp, "Custom Kickstart %s\r\nSize: 1 MB\r\nYear: ----\r\nChecksum: %s)\r\nCPU: 680x0\r\n", ver[csel], smsg);
     else
      {if(csel==12) sfpu = " + FPU 68881"; else sfpu = ""; // Kickstart 2.01 (36.143) wymaga koprocesora matematycznego minimum 68881
       sprintf(stmp, "Kickstart %s for Amiga %s\r\nSize: %d kB\r\nYear: %d %s\r\nChecksum: %s)\r\nCPU: 680%s-bit)%s\r\n", ver[csel], ami[csel], fsil/1024, yea[csel], inf[csel], smsg, scpu[cpu[csel]], sfpu);}
     SendMessage(hWin0, WM_SETTEXT, 0, stmp); // Wywietlenie informacji o otwartym Kickstarcie
     SendMessage(hWin3, STM_SETIMAGE, 1, hIcon); // Wywietlenie wczytanej ikony
// Zmiany w interfejsie programu
     SendMessage(hBut3, BM_SETSTYLE, 0, 1); // Usunicie ramki z przycisku "Quit" (jeli by wczeniej zaznaczony)
     EnableWindow(hBut0, 0); // Zablokowanie przycisku "Open..."
     SendMessage(hBut0, BM_SETSTYLE, 0, 1); // Usunicie ramki z przycisku "Open..."
     EnableWindow(hBut2, 1); // Odblokowanie przycisku "Close"
     SendMessage(hBut2, BM_SETSTYLE, BS_DEFPUSHBUTTON, 1); // Ustawienie ramki na przycisku "Close"
     SetFocus(hBut2); // Ustawienie fokusu na przycisku "Close"
     EnableWindow(hBut1, 1); // Odblokowanie przycisku "Save report..."
     EnableWindow(hWin1, 1); // Odblokowanie okna z napisem "Resident modules:"
     sprintf(smsg, "%s %d\r\n\r\n", stm1, mnum+1);
     SendMessage(hWin1, WM_SETTEXT, 0, smsg); // Wywietlenie liczby moduw rezydentnych w otwartym Kickstarcie
     strcat(stmp, smsg); // Dodanie zawartoci cigu "smsg" do cigu "stmp"
// Wypenianie listy "Resident modules" nazwami moduw rezydentnych z otwartego Kickstartu
     for(csel=0; csel<mnum+1; csel=csel+1)
      {SendMessage(hLis0, LB_ADDSTRING, 0, mnam[csel]);}
     EnableWindow(hLis0, 1);} // Odblokowanie listy "Resident modules"
   break;

// Wybranie przycisku "Save report..."
   case ID_SAVE:
   if(FileSelect(1)) // Wskazano plik w oknie wyboru do zapisu raportu tekstowego o otwartym Kickstarcie
    {sprintf(stm0, "Error saving report file");
     hFile = CreateFile(fnam, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, 0, 0);
     if(hFile==INVALID_HANDLE_VALUE) // Nie mona otworzy pliku do zapisu
K:    {sprintf(smsg, "Can't open this file for write%s", stm3);
L:     MessageBox(hwnd, smsg, stm0, MB_ICONERROR);
       break;}
// Zapisywanie nagwka z informacjami o otwartym Kickstarcie
     if(!WriteFile(hFile, stmp, strlen(stmp), &fsih, 0)) // Nie mona zapisa danych do pliku
M:    {sprintf(smsg, "Can't write data to%s", stm4);
       CloseHandle(hFile); // Zamknicie otwartego pliku
       goto L;}
     if(strlen(stmp)!=fsih) goto M; // Nie zapisano wszystkich danych do pliku
// Zapisywanie informacji o kadym module rezydentnym w otwartym Kickstarcie
     for(skip=0; skip<mnum+1; skip=skip+1)
      {sprintf(smsg, "%2d: %6X  %-32s  %s\r\n", skip+1, tadr[skip], mnam[skip], mver[skip]);
       if(!WriteFile(hFile, smsg, strlen(smsg), &fsih, 0)) goto M; // Nie mona zapisa danych do pliku
       if(strlen(smsg)!=fsih) goto M;} // Nie zapisano wszystkich danych do pliku
     CloseHandle(hFile);} // Zamknicie otwartego pliku
   break;
  
// Wybranie przycisku "Extract..."
   case ID_EXTR:
   if(FileSelect(2)) // Wskazano plik w oknie wyboru do zapisu binarnego moduu rezydentnego
    {sprintf(stm0, "Error saving resident module file");
     hFile = CreateFile(fnam, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, 0, 0);
     if(hFile==INVALID_HANDLE_VALUE) goto K; // Nie mona otworzy pliku do zapisu
// Zapisywanie wybranego z listy "Resident modules" moduu rezydentnego
     if(!WriteFile(hFile, madr[csel], mend[csel]-madr[csel], &fsih, 0)) goto M; // Nie mona zapisa danych do pliku
     if(mend[csel]-madr[csel]!=fsih) goto M; // Nie zapisano wszystkich danych do pliku
     CloseHandle(hFile);} // Zamknicie otwartego pliku
   break;

// Wybranie przycisku "Close"
   case ID_CLOSE:
   GlobalFree(mBuf); // Oddanie zarezerwowanej pamici
   load = 0; // Nie ma zarezerwowanej pamici do oddania z wczytanym obrazem Kickstartu
   DragAcceptFiles(hwnd, 1); // Wczenie wrzucania obiektw do gwnego okna programu (drag&drop)
// Zmiany w interfejsie programu
   EnableWindow(hBut2, 0); // Zablokowanie przycisku "Close"
   SendMessage(hBut2, BM_SETSTYLE, 0, 1); // Usunicie ramki z przycisku "Close"
   EnableWindow(hBut1, 0); // Zablokowanie przycisku "Save report..."
   EnableWindow(hBut0, 1); // Odblokowanie przycisku "Open..."
   SendMessage(hBut0, BM_SETSTYLE, BS_DEFPUSHBUTTON, 1); // Ustawienie ramki na przycisku "Open..."
   SetFocus(hBut0); // Ustawienie fokusu na przycisku "Open..."
   EnableWindow(hBut6, 0); // Zablokowanie przycisku "Extract..."
   EnableWindow(hLis0, 0); // Zablokowanie listy "Resident modules"
   SendMessage(hLis0, LB_RESETCONTENT, 0, 0); // Czyszczenie listy "Resident modules"
   EnableWindow(hWin1, 0); // Zablokowanie okna z napisem "Resident modules:"
   SendMessage(hWin1, WM_SETTEXT, 0, stm1); // Wywietlenie standardowego napisu
   EnableWindow(hWin2, 0); // Zablokowanie okna z informacjami o module rezydentnym
   SendMessage(hWin2, WM_SETTEXT, 0, stm2); // Wywietlenie standardowego napisu
   EnableWindow(hBut5, 0); // Zablokowanie grupy "Selected module"
// Wywietlanie informacji o programie
   SendMessage(hWin0, WM_SETTEXT, 0, sver); // Wywietlenie informacji o programie
   hIcon = LoadIcon(0, IDI_INFORMATION); // Wczytanie ikony informacji systemu Windows
   SendMessage(hWin3, STM_SETIMAGE, 1, hIcon); // Wywietlenie wczytanej ikony
   break;

// Wybranie przycisku "Quit"
   case ID_QUIT:
   SendMessage(hwnd, WM_DESTROY, 0, 0);
   break;
   }
  break;

// Wybranie pozycji z listy "Resident modules"
  case LBN_SELCHANGE:
  csel = SendMessage(hLis0, LB_GETCURSEL, 0, 0); // Numer aktualnie wybranej pozycji z listy
// Zmiany w interfejsie programu
  EnableWindow(hBut5, 1); // Odblokowanie grupy "Selected module"
  EnableWindow(hWin2, 1); // Odblokowanie okna z informacjami o module rezydentnym
// Ustalenie typu wybranego moduu rezydentnego
  typ[0] = "Unknown";
  if(mtyp[csel]==1) typ[0] = "Task";
  if(mtyp[csel]==3) typ[0] = "Device";
  if(mtyp[csel]==8) typ[0] = "Resource";
  if(mtyp[csel]==9) typ[0] = "Library";
// Wywietlenie informacji o wybranym z listy module rezydentnym
  sprintf(smsg, " Version: %s\nAddress: %6X\n    Type: %s\n  Priority: %d", mver[csel], tadr[csel], typ[0], mpri[csel]);
  SendMessage(hWin2, WM_SETTEXT, 0, smsg);
  EnableWindow(hBut6, 1); // Odblokowanie przycisku "Extract..."
  break;

// Zaznaczenie przycisku "Open...", "Close", "Save report...", "Quit" lub "Extract..." (myszk lub klawiatur)
  case BN_SETFOCUS:
  hTemp = lParam;
  break;
  }
 break;

// Wrzucenie obiektu/obiektw do gwnego okna programu (drag&drop)
 case WM_DROPFILES:
 DragQueryFile(wParam, 0, fnam, MAX_PATH); // Ustalenie cieki dostpu do pierwszego wrzuconego obiektu (znajdowa si na nim wskanik myszki)
 DragFinish(wParam); // Oddanie pamici z nazwami wrzuconych obiektw
// Sprawdzanie, czy pierwszy wrzucony obiekt jest plikiem/katalogiem
 if(OpenFile(fnam, &ofs, OF_EXIST)==HFILE_ERROR) // Obiekt jest katalogiem lub plikiem, ktrego nie da si otworzy do odczytu
  {sprintf(smsg, "\nCan't open this object for read%s", stm3);
   goto A;}
 else goto Y; // Obiekt jest plikiem i da si go otworzy do odczytu
 break;

// Aktywacja gwnego okna programu
 case WM_SETFOCUS:
 SendMessage(hTemp, BM_SETSTYLE, BS_DEFPUSHBUTTON, 1); // Ustawienie ramki na ostatnio zaznaczonym przycisku
 SetFocus(hTemp); // Ustawienie fokusu na ostatnio zaznaczonym przycisku
 break;

// Zmiana koloru ta listy "Resident modules"
 case WM_CTLCOLORLISTBOX:
  if(lParam==hLis0)
   {SetBkColor(wParam, hCol);
    return hbLis;}
 break;

// Niszczenie gwnego okna programu
 case WM_DESTROY:
// Sprawdzanie, czy zarezerwowana pami z wczytanym obrazem Kickstartu zostaa oddana
 if(load) GlobalFree(mBuf); // Oddanie zarezerwowanej pamici
 DestroyIcon(hIcon); // Niszczenie wczytanej ikony
 DeleteObject(hbLis); // Usuwanie brusha
 PostQuitMessage(0);
 break;

 default:
 return DefWindowProc(hwnd, Message, wParam, lParam);
 }
return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
MSG Msg;
WNDCLASSEX WndClass;
hInst = hInstance;
/* Krok 1: rejestrowanie klasy gwnego okna programu */
WndClass.cbSize        = sizeof(WNDCLASSEX);
WndClass.style         = 0;
WndClass.lpfnWndProc   = WndProc;
WndClass.cbClsExtra    = 0;
WndClass.cbWndExtra    = 0;
WndClass.hInstance     = hInst;
WndClass.hCursor       = LoadCursor(0, IDC_ARROW);
WndClass.hIcon         = LoadIcon(hInst, MAKEINTRESOURCE(ID_ICON));
WndClass.hIconSm       = LoadIcon(hInst, MAKEINTRESOURCE(ID_ICON));
WndClass.hbrBackground = (HBRUSH)COLOR_BTNSHADOW;
WndClass.lpszMenuName  = 0;
WndClass.lpszClassName = scla;
if(!RegisterClassEx(&WndClass))
 {MessageBox(0, "Window Registration Failed!", "Error!", MB_ICONERROR);
  return 0;}
// Centrowanie gwnego okna programu
scrx = GetSystemMetrics(SM_CXSCREEN); // Szeroko aktualnego ekranu
scry = GetSystemMetrics(SM_CYSCREEN); // Wysoko aktualnego ekranu
/* Krok 2: tworzenie gwnego okna programu */
hWnd = CreateWindowEx(WS_EX_ACCEPTFILES, scla, snam, WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX, (scrx-winx)/2, (scry-winy)/2, winx, winy, 0, 0, hInst, 0);
if(!hWnd)
 {MessageBox(0, "Window Creation Failed!", "Error!", MB_ICONERROR);
  return 0;}
ShowWindow(hWnd, nCmdShow);
UpdateWindow(hWnd);
/* Krok 3: ptla wiadomoci gwnego okna programu */
  while(GetMessage(&Msg, 0, 0, 0) > 0)
   {if(!IsDialogMessage(hWnd, &Msg))
     {TranslateMessage(&Msg);
      DispatchMessage(&Msg);}}
return Msg.wParam;
}

// Funkcja wywietla okno wyboru plikw
BOOL FileSelect(int fmod)
{
ZeroMemory(&ofn, sizeof(ofn));
ofn.lStructSize = sizeof(ofn);
ofn.hwndOwner = hWnd;
ofn.lpstrFile = fnam;
ofn.nMaxFile = MAX_PATH;
if(fmod) // Wybr pliku do zapisu
 {ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  if(fmod==1)
   {ofn.lpstrFilter = "Text Files (*.txt)\0*.txt\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrDefExt = "txt";}
  else
   {ofn.lpstrFilter = "Binary Files (*.bin)\0*.bin\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrDefExt = "bin";}
  if(!GetSaveFileName(&ofn)) return 0;}
else // Wybr pliku do odczytu
 {ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
  ofn.lpstrFilter = "Kickstart Images (*.rom)\0*.rom\0All Files (*.*)\0*.*\0\0";
  ofn.lpstrDefExt = "rom";
  if(!GetOpenFileName(&ofn)) return 0;}
return 1;
}

/* Funkcja sprawdza dugo cigu ASCIIZ spod adresu "stri" i jeli jest on pusty, krtszy ni 3 bajty lub duszy ni
   "snum"-bajtw, to funkcja zwraca 0. W przeciwnym razie funkcja kopiuje ten cig pod adres "dest" i szuka w nim nie-
   dozwolonych bajtw. Jeli w cigu "dest" znajduj si bajty inne ni: "0"-"9", "A"-"Z", "a"-"z", ".", ",", "-", "(",
   ")", "_", "/", ":", " " (spacja), 0x0A i 0x0D, to funkcja zwraca 0. Wszystkie bajty 0x0A i 0x0D w cigu "dest" s
   zamieniane na bajty 0x00. Jeli po tej operacji cig "dest" jest pusty lub krtszy ni 3 bajty, to funkcja zwraca 0.
   W przeciwnym razie funkcja zwraca 1. */
BOOL CheckString(char *stri, char *dest, int snum)
{
int slen = strlen(stri);
if(slen<3 || slen>snum) return 0; // Pusty, zbyt krtki lub zbyt dugi cig "stri"
strcpy(dest, stri); // Kopiowanie cigu
// Szukanie niedozwolonych bajtw w cigu
for(snum=0; snum<slen; snum=snum+1)
 {ctst[0] = dest[snum];
  if((ctst[0]==169 || ctst[0]==171 || ctst[0]==187) && ks1m==1) continue; // Dozwolony bajt 0xA9, 0xAB lub 0xBB w Kickstarcie 1MB
  if(ctst[0]>122) return 0; // Niedozwolony bajt 0x7B-0xFF
  if(ctst[0]<97 && ctst[0]>90)
   {if(ctst[0]!=95) return 0;} // Niedozwolony bajt 0x5B-0x5E lub 0x60
  if(ctst[0]<65 && ctst[0]>58) return 0; // Niedozwolony bajt 0x3B-0x40
  if(ctst[0]<44)
   {if(ctst[0]!=40 && ctst[0]!=41 && ctst[0]!=32)
     {if(ctst[0]!=10 && ctst[0]!=13) return 0; // Niedozwolony bajt 0x01-0x09, 0x0B-0x0C, 0x0E-0x1F, 0x21-0x27 lub 0x2A-0x2B
      else dest[snum] = 0;}}} // Zamiana bajtu 0x0A lub 0x0D na bajt 0x00
if(strlen(dest)<3) return 0; // Pusty lub zbyt krtki cig "dest"
return 1;
}
